<?php
declare(strict_types=1);

use App\Services\ErrorHandler;

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

date_default_timezone_set('UTC');

if (!defined('APP_BASE_URL')) {
    $scriptName = str_replace('\\', '/', (string) ($_SERVER['SCRIPT_NAME'] ?? ''));
    $scriptDir = str_replace('\\', '/', dirname($scriptName));

    if ($scriptDir === '/' || $scriptDir === '.' || str_starts_with($scriptDir, 'Standard input')) {
        $scriptDir = '';
    }

    define('APP_BASE_URL', rtrim($scriptDir, '/'));
}

if (!defined('STORAGE_PATH')) {
    define('STORAGE_PATH', BASE_PATH . '/storage');
}

if (!defined('LOG_PATH')) {
    define('LOG_PATH', STORAGE_PATH . '/logs/app.log');
}

spl_autoload_register(static function (string $class): void {
    $prefix = 'App\\';

    if (strncmp($class, $prefix, strlen($prefix)) !== 0) {
        return;
    }

    $relativeClass = substr($class, strlen($prefix));
    $file = BASE_PATH . '/app/' . str_replace('\\', '/', $relativeClass) . '.php';

    if (is_file($file)) {
        require $file;
    }
});

require BASE_PATH . '/app/helpers.php';

if (!is_dir(STORAGE_PATH . '/logs')) {
    mkdir(STORAGE_PATH . '/logs', 0775, true);
}

if (!is_dir(STORAGE_PATH . '/backups')) {
    mkdir(STORAGE_PATH . '/backups', 0775, true);
}

ErrorHandler::register(LOG_PATH);
