<?php
$createValues = [
    'name' => $oldInput['name'] ?? '',
    'email' => $oldInput['email'] ?? '',
    'is_active' => (string) ($oldInput['is_active'] ?? '1'),
    'roles' => is_array($oldInput['roles'] ?? null) ? $oldInput['roles'] : [],
];
?>

<div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
    <h1 class="h3 mb-0">إدارة المستخدمين</h1>
</div>

<div class="row g-4">
    <div class="col-lg-4">
        <form method="post" action="<?= e(url('/users/store')) ?>" class="card shadow-sm">
            <div class="card-body">
                <h2 class="h5 mb-3">إضافة مستخدم</h2>
                <?= csrf_field() ?>
                <div class="mb-3">
                    <label class="form-label">الاسم</label>
                    <input type="text" name="name" class="form-control" maxlength="120" required value="<?= e((string) $createValues['name']) ?>">
                </div>
                <div class="mb-3">
                    <label class="form-label">البريد الإلكتروني</label>
                    <input type="email" name="email" class="form-control" required value="<?= e((string) $createValues['email']) ?>">
                </div>
                <div class="mb-3">
                    <label class="form-label">كلمة المرور</label>
                    <input type="password" name="password" class="form-control" minlength="8" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">الحالة</label>
                    <select name="is_active" class="form-select">
                        <option value="1" <?= $createValues['is_active'] === '1' ? 'selected' : '' ?>>نشط</option>
                        <option value="0" <?= $createValues['is_active'] === '0' ? 'selected' : '' ?>>موقوف</option>
                    </select>
                </div>
                <div class="mb-0">
                    <label class="form-label">الأدوار</label>
                    <select name="roles[]" class="form-select" multiple size="4" required>
                        <?php foreach ($roles as $role): ?>
                            <option value="<?= e($role['id']) ?>" <?= in_array($role['id'], $createValues['roles'], true) ? 'selected' : '' ?>>
                                <?= e($role['display_name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            <div class="card-footer bg-white d-flex justify-content-end">
                <button type="submit" class="btn btn-primary">إنشاء</button>
            </div>
        </form>
    </div>

    <div class="col-lg-8">
        <div class="card shadow-sm">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0 align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>الاسم</th>
                                <th>البريد</th>
                                <th>الأدوار</th>
                                <th>الحالة</th>
                                <th class="text-end">الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php if ($users === []): ?>
                            <tr><td colspan="5" class="text-center py-4 text-muted">لا يوجد مستخدمون.</td></tr>
                        <?php else: ?>
                            <?php foreach ($users as $user): ?>
                                <tr>
                                    <td><?= e($user['name']) ?></td>
                                    <td><?= e($user['email']) ?></td>
                                    <td><?= e($user['roles_text'] !== '' ? $user['roles_text'] : '-') ?></td>
                                    <td><?= (int) $user['is_active'] === 1 ? 'نشط' : 'موقوف' ?></td>
                                    <td class="text-end">
                                        <a href="<?= e(url('/users/edit?id=' . $user['id'])) ?>" class="btn btn-sm btn-outline-primary">تعديل</a>
                                        <form method="post" action="<?= e(url('/users/toggle-active')) ?>" class="d-inline">
                                            <?= csrf_field() ?>
                                            <input type="hidden" name="id" value="<?= e($user['id']) ?>">
                                            <button type="submit" class="btn btn-sm btn-outline-warning">
                                                <?= (int) $user['is_active'] === 1 ? 'إيقاف' : 'تفعيل' ?>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
