<?php
$values = [
    'id' => $oldInput['id'] ?? $user['id'],
    'name' => $oldInput['name'] ?? $user['name'],
    'email' => $oldInput['email'] ?? $user['email'],
    'is_active' => (string) ($oldInput['is_active'] ?? $user['is_active']),
    'roles' => is_array($oldInput['roles'] ?? null) ? $oldInput['roles'] : $userRoleIds,
];
?>

<div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
    <h1 class="h3 mb-0">تعديل المستخدم</h1>
    <a class="btn btn-outline-secondary" href="<?= e(url('/users')) ?>">العودة</a>
</div>

<form method="post" action="<?= e(url('/users/update')) ?>" class="card shadow-sm">
    <div class="card-body p-4">
        <?= csrf_field() ?>
        <input type="hidden" name="id" value="<?= e((string) $values['id']) ?>">
        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label">الاسم</label>
                <input type="text" name="name" class="form-control" maxlength="120" required value="<?= e((string) $values['name']) ?>">
            </div>
            <div class="col-md-6">
                <label class="form-label">البريد الإلكتروني</label>
                <input type="email" name="email" class="form-control" required value="<?= e((string) $values['email']) ?>">
            </div>
            <div class="col-md-6">
                <label class="form-label">كلمة مرور جديدة (اختياري)</label>
                <input type="password" name="password" class="form-control" minlength="8">
            </div>
            <div class="col-md-6">
                <label class="form-label">الحالة</label>
                <select name="is_active" class="form-select">
                    <option value="1" <?= $values['is_active'] === '1' ? 'selected' : '' ?>>نشط</option>
                    <option value="0" <?= $values['is_active'] === '0' ? 'selected' : '' ?>>موقوف</option>
                </select>
            </div>
            <div class="col-12">
                <label class="form-label">الأدوار</label>
                <select name="roles[]" class="form-select" multiple size="6" required>
                    <?php foreach ($roles as $role): ?>
                        <option value="<?= e($role['id']) ?>" <?= in_array($role['id'], $values['roles'], true) ? 'selected' : '' ?>>
                            <?= e($role['display_name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>
    </div>
    <div class="card-footer bg-white d-flex justify-content-end">
        <button type="submit" class="btn btn-primary">حفظ التعديلات</button>
    </div>
</form>
