<?php
$values = [
    'system_name' => $oldInput['system_name'] ?? $settings['system_name'],
    'currency_code' => $oldInput['currency_code'] ?? $settings['currency_code'],
    'number_format' => $oldInput['number_format'] ?? $settings['number_format'],
    'calendar_type' => $oldInput['calendar_type'] ?? $settings['calendar_type'],
    'language' => $oldInput['language'] ?? ($settings['language'] ?? 'ar'),
    'rtl' => (string) ($oldInput['rtl'] ?? $settings['rtl']),
];

$categoryOldType = ($oldInput['type'] ?? '') === 'expense' ? 'expense' : 'income';
$categoryOldName = (string) ($oldInput['name'] ?? '');
?>

<div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
    <h1 class="h3 mb-0">الإعدادات</h1>
</div>

<form method="post" action="<?= e(url('/settings')) ?>" class="card shadow-sm mb-4">
    <div class="card-body p-4">
        <h2 class="h5 mb-3">الإعدادات العامة</h2>
        <?= csrf_field() ?>

        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label">اسم النظام</label>
                <input type="text" name="system_name" class="form-control" maxlength="100" required value="<?= e($values['system_name']) ?>">
            </div>

            <div class="col-md-6">
                <label class="form-label">رمز العملة</label>
                <input type="text" name="currency_code" class="form-control" maxlength="10" required value="<?= e($values['currency_code']) ?>">
            </div>

            <div class="col-md-6">
                <label class="form-label">صيغة الأرقام</label>
                <select name="number_format" class="form-select" required>
                    <option value="1,234.56" <?= $values['number_format'] === '1,234.56' ? 'selected' : '' ?>>1,234.56</option>
                    <option value="1.234,56" <?= $values['number_format'] === '1.234,56' ? 'selected' : '' ?>>1.234,56</option>
                </select>
            </div>

            <div class="col-md-6">
                <label class="form-label">نوع التقويم</label>
                <select name="calendar_type" class="form-select" required>
                    <option value="gregorian" <?= $values['calendar_type'] === 'gregorian' ? 'selected' : '' ?>>ميلادي</option>
                    <option value="hijri" <?= $values['calendar_type'] === 'hijri' ? 'selected' : '' ?>>هجري</option>
                </select>
            </div>

            <div class="col-md-6">
                <label class="form-label">اللغة</label>
                <select name="language" class="form-select" required>
                    <option value="ar" <?= $values['language'] === 'ar' ? 'selected' : '' ?>>العربية</option>
                    <option value="en" <?= $values['language'] === 'en' ? 'selected' : '' ?>>English</option>
                </select>
            </div>

            <div class="col-md-6">
                <label class="form-label">اتجاه الواجهة</label>
                <select name="rtl" class="form-select" required>
                    <option value="1" <?= $values['rtl'] === '1' ? 'selected' : '' ?>>من اليمين إلى اليسار (RTL)</option>
                    <option value="0" <?= $values['rtl'] === '0' ? 'selected' : '' ?>>من اليسار إلى اليمين (LTR)</option>
                </select>
            </div>
        </div>
    </div>
    <div class="card-footer bg-white d-flex justify-content-end">
        <button type="submit" class="btn btn-primary">حفظ الإعدادات</button>
    </div>
</form>

<?php if (can('categories.manage')): ?>
<div id="categories" class="card shadow-sm">
    <div class="card-body p-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h2 class="h5 mb-0">إدارة التصنيفات (من قاعدة البيانات)</h2>
        </div>

        <div class="row g-4">
            <div class="col-lg-6">
                <h3 class="h6 mb-2">تصنيفات الإيرادات</h3>

                <form method="post" action="<?= e(url('/categories/store')) ?>" class="row g-2 mb-3">
                    <?= csrf_field() ?>
                    <input type="hidden" name="type" value="income">
                    <input type="hidden" name="return_to" value="/settings#categories">
                    <div class="col-8">
                        <input type="text" name="name" class="form-control" maxlength="100" required placeholder="اسم التصنيف"
                               value="<?= $categoryOldType === 'income' ? e($categoryOldName) : '' ?>">
                    </div>
                    <div class="col-4 d-grid">
                        <button type="submit" class="btn btn-outline-primary">إضافة</button>
                    </div>
                </form>

                <div class="table-responsive">
                    <table class="table table-sm align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>الاسم</th>
                                <th>الحالة</th>
                                <th class="text-end">الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($incomeCategories as $category): ?>
                            <tr>
                                <td>
                                    <form method="post" action="<?= e(url('/categories/update')) ?>" class="d-flex gap-2 align-items-center">
                                        <?= csrf_field() ?>
                                        <input type="hidden" name="id" value="<?= e($category['id']) ?>">
                                        <input type="hidden" name="type" value="income">
                                        <input type="hidden" name="is_active" value="<?= e((string) $category['is_active']) ?>">
                                        <input type="hidden" name="return_to" value="/settings#categories">
                                        <input type="text" name="name" class="form-control form-control-sm" maxlength="100" required value="<?= e($category['name']) ?>">
                                        <button type="submit" class="btn btn-sm btn-outline-primary">حفظ الاسم</button>
                                    </form>
                                </td>
                                <td style="min-width: 120px;">
                                    <form method="post" action="<?= e(url('/categories/update')) ?>" class="d-flex gap-2 align-items-center">
                                        <?= csrf_field() ?>
                                        <input type="hidden" name="id" value="<?= e($category['id']) ?>">
                                        <input type="hidden" name="type" value="income">
                                        <input type="hidden" name="name" value="<?= e($category['name']) ?>">
                                        <input type="hidden" name="return_to" value="/settings#categories">
                                        <select name="is_active" class="form-select form-select-sm">
                                            <option value="1" <?= (int) $category['is_active'] === 1 ? 'selected' : '' ?>>نشط</option>
                                            <option value="0" <?= (int) $category['is_active'] === 0 ? 'selected' : '' ?>>مؤرشف</option>
                                        </select>
                                        <button type="submit" class="btn btn-sm btn-outline-primary">حفظ الحالة</button>
                                    </form>
                                </td>
                                <td class="text-end" style="min-width: 180px;">
                                    <?php if ((int) $category['is_active'] === 1): ?>
                                        <form method="post" action="<?= e(url('/categories/deactivate')) ?>" class="d-inline">
                                            <?= csrf_field() ?>
                                            <input type="hidden" name="id" value="<?= e($category['id']) ?>">
                                            <input type="hidden" name="type" value="income">
                                            <input type="hidden" name="return_to" value="/settings#categories">
                                            <button type="submit" class="btn btn-sm btn-outline-danger" onclick="return confirm('تأكيد تعطيل التصنيف؟');">تعطيل</button>
                                        </form>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="col-lg-6">
                <h3 class="h6 mb-2">تصنيفات المصروفات</h3>

                <form method="post" action="<?= e(url('/categories/store')) ?>" class="row g-2 mb-3">
                    <?= csrf_field() ?>
                    <input type="hidden" name="type" value="expense">
                    <input type="hidden" name="return_to" value="/settings#categories">
                    <div class="col-8">
                        <input type="text" name="name" class="form-control" maxlength="100" required placeholder="اسم التصنيف"
                               value="<?= $categoryOldType === 'expense' ? e($categoryOldName) : '' ?>">
                    </div>
                    <div class="col-4 d-grid">
                        <button type="submit" class="btn btn-outline-primary">إضافة</button>
                    </div>
                </form>

                <div class="table-responsive">
                    <table class="table table-sm align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>الاسم</th>
                                <th>الحالة</th>
                                <th class="text-end">الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($expenseCategories as $category): ?>
                            <tr>
                                <td>
                                    <form method="post" action="<?= e(url('/categories/update')) ?>" class="d-flex gap-2 align-items-center">
                                        <?= csrf_field() ?>
                                        <input type="hidden" name="id" value="<?= e($category['id']) ?>">
                                        <input type="hidden" name="type" value="expense">
                                        <input type="hidden" name="is_active" value="<?= e((string) $category['is_active']) ?>">
                                        <input type="hidden" name="return_to" value="/settings#categories">
                                        <input type="text" name="name" class="form-control form-control-sm" maxlength="100" required value="<?= e($category['name']) ?>">
                                        <button type="submit" class="btn btn-sm btn-outline-primary">حفظ الاسم</button>
                                    </form>
                                </td>
                                <td style="min-width: 120px;">
                                    <form method="post" action="<?= e(url('/categories/update')) ?>" class="d-flex gap-2 align-items-center">
                                        <?= csrf_field() ?>
                                        <input type="hidden" name="id" value="<?= e($category['id']) ?>">
                                        <input type="hidden" name="type" value="expense">
                                        <input type="hidden" name="name" value="<?= e($category['name']) ?>">
                                        <input type="hidden" name="return_to" value="/settings#categories">
                                        <select name="is_active" class="form-select form-select-sm">
                                            <option value="1" <?= (int) $category['is_active'] === 1 ? 'selected' : '' ?>>نشط</option>
                                            <option value="0" <?= (int) $category['is_active'] === 0 ? 'selected' : '' ?>>مؤرشف</option>
                                        </select>
                                        <button type="submit" class="btn btn-sm btn-outline-primary">حفظ الحالة</button>
                                    </form>
                                </td>
                                <td class="text-end" style="min-width: 180px;">
                                    <?php if ((int) $category['is_active'] === 1): ?>
                                        <form method="post" action="<?= e(url('/categories/deactivate')) ?>" class="d-inline">
                                            <?= csrf_field() ?>
                                            <input type="hidden" name="id" value="<?= e($category['id']) ?>">
                                            <input type="hidden" name="type" value="expense">
                                            <input type="hidden" name="return_to" value="/settings#categories">
                                            <button type="submit" class="btn btn-sm btn-outline-danger" onclick="return confirm('تأكيد تعطيل التصنيف؟');">تعطيل</button>
                                        </form>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php else: ?>
    <div id="categories" class="alert alert-secondary">ليس لديك صلاحية إدارة التصنيفات.</div>
<?php endif; ?>
