<?php
$createValues = [
    'person_name' => $oldInput['person_name'] ?? '',
    'amount' => $oldInput['amount'] ?? '',
    'expected_receive_date' => $oldInput['expected_receive_date'] ?? date('Y-m-d'),
    'status' => $oldInput['status'] ?? 'sent',
    'notes' => $oldInput['notes'] ?? '',
];
$statuses = [
    'sent' => 'مرسل',
    'received' => 'تم الاستلام',
    'overdue' => 'متأخر',
    'cancelled' => 'ملغي',
];
?>

<div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
    <h1 class="h3 mb-0">المبالغ المرسلة</h1>
</div>

<div class="row g-4">
    <div class="col-lg-4">
        <form method="post" action="<?= e(url('/sent-money/store')) ?>" class="card shadow-sm">
            <div class="card-body">
                <h2 class="h5 mb-3">إضافة سجل</h2>
                <?= csrf_field() ?>

                <div class="mb-3">
                    <label class="form-label">اسم الشخص</label>
                    <input type="text" name="person_name" class="form-control" maxlength="120" required value="<?= e((string) $createValues['person_name']) ?>">
                </div>
                <div class="mb-3">
                    <label class="form-label">المبلغ</label>
                    <input type="number" step="0.01" min="0.01" name="amount" class="form-control" required value="<?= e((string) $createValues['amount']) ?>">
                </div>
                <div class="mb-3">
                    <label class="form-label">تاريخ الاستلام المتوقع</label>
                    <input type="date" name="expected_receive_date" class="form-control" required value="<?= e((string) $createValues['expected_receive_date']) ?>">
                </div>
                <div class="mb-3">
                    <label class="form-label">الحالة</label>
                    <select name="status" class="form-select" required>
                        <?php foreach ($statuses as $key => $label): ?>
                            <option value="<?= e($key) ?>" <?= $createValues['status'] === $key ? 'selected' : '' ?>><?= e($label) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="mb-0">
                    <label class="form-label">ملاحظات</label>
                    <textarea name="notes" class="form-control" rows="3" maxlength="1000"><?= e((string) $createValues['notes']) ?></textarea>
                </div>
            </div>
            <div class="card-footer bg-white d-flex justify-content-end">
                <button type="submit" class="btn btn-primary">حفظ</button>
            </div>
        </form>
    </div>

    <div class="col-lg-8">
        <div class="card shadow-sm mb-3">
            <div class="card-body">
                <form method="get" action="<?= e(url('/sent-money')) ?>" class="row g-2 align-items-end">
                    <div class="col-md-8">
                        <label class="form-label">فلترة حسب الحالة</label>
                        <select name="status" class="form-select">
                            <option value="all" <?= $statusFilter === 'all' ? 'selected' : '' ?>>الكل</option>
                            <?php foreach ($statuses as $key => $label): ?>
                                <option value="<?= e($key) ?>" <?= $statusFilter === $key ? 'selected' : '' ?>><?= e($label) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-4 d-flex gap-2">
                        <button type="submit" class="btn btn-outline-primary w-100">تصفية</button>
                        <a class="btn btn-outline-secondary w-100" href="<?= e(url('/sent-money')) ?>">إعادة</a>
                    </div>
                </form>
            </div>
        </div>

        <div class="card shadow-sm">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0 align-middle">
                        <thead class="table-light">
                        <tr>
                            <th>الشخص</th>
                            <th>المبلغ</th>
                            <th>التاريخ المتوقع</th>
                            <th>الحالة</th>
                            <th class="text-end">الإجراءات</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if ($records === []): ?>
                            <tr><td colspan="5" class="text-center py-4 text-muted">لا توجد سجلات.</td></tr>
                        <?php else: ?>
                            <?php foreach ($records as $record): ?>
                                <?php
                                $statusText = $statuses[$record['status']] ?? $record['status'];
                                if ((int) $record['is_overdue'] === 1 && $record['status'] === 'sent') {
                                    $statusText .= ' (متأخر)';
                                }
                                ?>
                                <tr class="<?= (int) $record['is_overdue'] === 1 ? 'table-warning' : '' ?>">
                                    <td><?= e($record['person_name']) ?></td>
                                    <td><?= e(format_money((float) $record['amount'])) ?></td>
                                    <td><?= e($record['expected_receive_date']) ?></td>
                                    <td><?= e($statusText) ?></td>
                                    <td class="text-end">
                                        <a class="btn btn-sm btn-outline-primary" href="<?= e(url('/sent-money/edit?id=' . $record['id'])) ?>">تعديل</a>
                                        <form method="post" action="<?= e(url('/sent-money/delete')) ?>" class="d-inline">
                                            <?= csrf_field() ?>
                                            <input type="hidden" name="id" value="<?= e($record['id']) ?>">
                                            <button type="submit" class="btn btn-sm btn-outline-danger" onclick="return confirm('تأكيد حذف السجل؟');">حذف</button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
