<div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
    <h1 class="h3 mb-0">البحث الشامل</h1>
</div>

<?php if ($errors !== []): ?>
    <div class="alert alert-warning"><?= e(implode(' ', $errors)) ?></div>
<?php endif; ?>

<div class="card shadow-sm mb-4">
    <div class="card-body">
        <form method="get" action="<?= e(url('/search')) ?>" class="row g-2 align-items-end">
            <div class="col-md-4">
                <label class="form-label">كلمة البحث</label>
                <input type="text" name="q" class="form-control" value="<?= e($keyword) ?>" placeholder="وصف، اسم شخص...">
            </div>
            <div class="col-md-3">
                <label class="form-label">من تاريخ</label>
                <input type="date" name="date_from" class="form-control" value="<?= e($dateFrom) ?>">
            </div>
            <div class="col-md-3">
                <label class="form-label">إلى تاريخ</label>
                <input type="date" name="date_to" class="form-control" value="<?= e($dateTo) ?>">
            </div>
            <div class="col-md-2 d-flex gap-2">
                <button type="submit" class="btn btn-primary w-100">بحث</button>
                <a href="<?= e(url('/search')) ?>" class="btn btn-outline-secondary w-100">إعادة</a>
            </div>
        </form>
    </div>
</div>

<?php if (!$hasQuery): ?>
    <div class="alert alert-info">أدخل كلمة بحث أو نطاق تاريخ لعرض النتائج.</div>
<?php else: ?>
    <?php
    $sections = [
        'incomes' => 'الإيرادات',
        'expenses' => 'المصروفات',
        'sent_money' => 'المبالغ المرسلة',
        'borrowed_money' => 'المبالغ المقترضة',
    ];
    ?>
    <?php foreach ($sections as $key => $title): ?>
        <div class="card shadow-sm mb-3">
            <div class="card-header bg-white d-flex justify-content-between align-items-center">
                <strong><?= e($title) ?></strong>
                <span class="badge text-bg-secondary"><?= e((string) count($results[$key])) ?></span>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0 align-middle">
                        <tbody>
                        <?php if ($results[$key] === []): ?>
                            <tr><td class="text-center py-4 text-muted">لا توجد نتائج.</td></tr>
                        <?php else: ?>
                            <?php foreach ($results[$key] as $row): ?>
                                <tr>
                                    <?php if ($key === 'incomes' || $key === 'expenses'): ?>
                                        <td><?= e($row['date']) ?></td>
                                        <td><?= e(display_description($row['description'])) ?></td>
                                        <td><?= e(format_money((float) $row['amount'])) ?></td>
                                    <?php elseif ($key === 'sent_money'): ?>
                                        <td><?= e($row['expected_receive_date']) ?></td>
                                        <td><?= e($row['person_name']) ?></td>
                                        <td><?= e($row['status']) ?></td>
                                        <td><?= e(format_money((float) $row['amount'])) ?></td>
                                    <?php else: ?>
                                        <td><?= e($row['expected_pay_date']) ?></td>
                                        <td><?= e($row['person_name']) ?></td>
                                        <td><?= e($row['status']) ?></td>
                                        <td><?= e(format_money((float) $row['amount'])) ?></td>
                                    <?php endif; ?>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
<?php endif; ?>
