<?php
$createValues = [
    'name' => (string) ($oldInput['name'] ?? ''),
    'display_name' => (string) ($oldInput['display_name'] ?? ''),
];
?>

<div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
    <h1 class="h3 mb-0">إدارة الأدوار والصلاحيات</h1>
</div>

<div class="row g-4">
    <div class="col-lg-4">
        <form method="post" action="<?= e(url('/roles/store')) ?>" class="card shadow-sm">
            <div class="card-body">
                <h2 class="h5 mb-3">إضافة دور</h2>
                <?= csrf_field() ?>
                <div class="mb-3">
                    <label class="form-label">اسم تقني (name)</label>
                    <input type="text" name="name" class="form-control" required value="<?= e($createValues['name']) ?>" placeholder="example: accountant">
                </div>
                <div class="mb-0">
                    <label class="form-label">اسم معروض</label>
                    <input type="text" name="display_name" class="form-control" maxlength="120" required value="<?= e($createValues['display_name']) ?>">
                </div>
            </div>
            <div class="card-footer bg-white d-flex justify-content-end">
                <button type="submit" class="btn btn-primary">إنشاء</button>
            </div>
        </form>
    </div>

    <div class="col-lg-8">
        <?php foreach ($roles as $role): ?>
            <?php $selected = $rolePermissions[$role['id']] ?? []; ?>
            <div class="card shadow-sm mb-3">
                <div class="card-header bg-white">
                    <div class="d-flex justify-content-between align-items-center gap-2 flex-wrap">
                        <strong><?= e($role['display_name']) ?> <small class="text-muted">(<?= e($role['name']) ?>)</small></strong>
                        <form method="post" action="<?= e(url('/roles/update-role')) ?>" class="d-flex gap-2 align-items-center">
                            <?= csrf_field() ?>
                            <input type="hidden" name="id" value="<?= e($role['id']) ?>">
                            <input type="text" name="display_name" class="form-control form-control-sm" value="<?= e($role['display_name']) ?>" required>
                            <select name="is_active" class="form-select form-select-sm">
                                <option value="1" <?= (int) $role['is_active'] === 1 ? 'selected' : '' ?>>نشط</option>
                                <option value="0" <?= (int) $role['is_active'] === 0 ? 'selected' : '' ?>>موقوف</option>
                            </select>
                            <button type="submit" class="btn btn-sm btn-outline-primary">حفظ</button>
                        </form>
                    </div>
                </div>
                <div class="card-body">
                    <form method="post" action="<?= e(url('/roles/update-permissions')) ?>">
                        <?= csrf_field() ?>
                        <input type="hidden" name="role_id" value="<?= e($role['id']) ?>">
                        <div class="row g-2">
                            <?php foreach ($permissions as $permission): ?>
                                <div class="col-md-6">
                                    <label class="form-check">
                                        <input class="form-check-input" type="checkbox" name="permissions[]" value="<?= e($permission['id']) ?>"
                                            <?= in_array($permission['id'], $selected, true) ? 'checked' : '' ?>>
                                        <span class="form-check-label"><?= e($permission['display_name']) ?></span>
                                    </label>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <div class="mt-3 d-flex justify-content-end">
                            <button type="submit" class="btn btn-outline-primary">حفظ صلاحيات الدور</button>
                        </div>
                    </form>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>
