<div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
    <h1 class="h3 mb-0">التقارير الشهرية</h1>
</div>

<div class="card shadow-sm mb-4">
    <div class="card-body">
        <form method="get" action="<?= e(url('/reports')) ?>" class="row g-2 align-items-end">
            <div class="col-md-4">
                <label class="form-label">الشهر</label>
                <input type="month" name="month" class="form-control" value="<?= e($month) ?>" required>
            </div>
            <div class="col-md-4 d-flex gap-2">
                <button type="submit" class="btn btn-primary w-100">عرض التقرير</button>
                <a href="<?= e(url('/reports/export?month=' . $month)) ?>" class="btn btn-outline-secondary w-100">تنزيل JSON</a>
            </div>
        </form>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-4">
        <div class="card shadow-sm h-100">
            <div class="card-body">
                <div class="text-muted small mb-1">إجمالي الإيرادات</div>
                <div class="h4 mb-0"><?= e(format_money((float) $summary['totals']['income'])) ?></div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card shadow-sm h-100">
            <div class="card-body">
                <div class="text-muted small mb-1">إجمالي المصروفات</div>
                <div class="h4 mb-0"><?= e(format_money((float) $summary['totals']['expense'])) ?></div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card shadow-sm h-100 border-primary">
            <div class="card-body">
                <div class="text-muted small mb-1">صافي الرصيد</div>
                <div class="h4 mb-0"><?= e(format_money((float) $summary['totals']['balance'])) ?></div>
            </div>
        </div>
    </div>
</div>

<div class="row g-3">
    <div class="col-lg-6">
        <div class="card shadow-sm">
            <div class="card-header bg-white"><strong>تفصيل الإيرادات حسب التصنيف</strong></div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr><th>التصنيف</th><th>الإجمالي</th></tr>
                        </thead>
                        <tbody>
                        <?php if ($summary['breakdown']['income'] === []): ?>
                            <tr><td colspan="2" class="text-center py-4 text-muted">لا توجد بيانات.</td></tr>
                        <?php else: ?>
                            <?php foreach ($summary['breakdown']['income'] as $item): ?>
                                <?php
                                $name = (string) $item['category_name'];
                                if ($item['category_is_active'] !== null && (int) $item['category_is_active'] === 0) {
                                    $name .= ' (Archived)';
                                }
                                ?>
                                <tr>
                                    <td><?= e($name) ?></td>
                                    <td><?= e(format_money((float) $item['total_amount'])) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-6">
        <div class="card shadow-sm">
            <div class="card-header bg-white"><strong>تفصيل المصروفات حسب التصنيف</strong></div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr><th>التصنيف</th><th>الإجمالي</th></tr>
                        </thead>
                        <tbody>
                        <?php if ($summary['breakdown']['expense'] === []): ?>
                            <tr><td colspan="2" class="text-center py-4 text-muted">لا توجد بيانات.</td></tr>
                        <?php else: ?>
                            <?php foreach ($summary['breakdown']['expense'] as $item): ?>
                                <?php
                                $name = (string) $item['category_name'];
                                if ($item['category_is_active'] !== null && (int) $item['category_is_active'] === 0) {
                                    $name .= ' (Archived)';
                                }
                                ?>
                                <tr>
                                    <td><?= e($name) ?></td>
                                    <td><?= e(format_money((float) $item['total_amount'])) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
