<?php
$values = [
    'id' => $oldInput['id'] ?? $record['id'],
    'title' => $oldInput['title'] ?? $record['title'],
    'amount' => $oldInput['amount'] ?? ($record['amount'] ?? ''),
    'due_date' => $oldInput['due_date'] ?? $record['due_date'],
    'status' => $oldInput['status'] ?? $record['status'],
    'notes' => $oldInput['notes'] ?? ($record['notes'] ?? ''),
];
$statuses = [
    'pending' => 'قيد الانتظار',
    'confirmed' => 'مؤكد',
    'postponed' => 'مؤجل',
    'cancelled' => 'ملغي',
];
?>

<div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
    <h1 class="h3 mb-0">تعديل التذكير</h1>
    <a class="btn btn-outline-secondary" href="<?= e(url('/reminders')) ?>">العودة للقائمة</a>
</div>

<form method="post" action="<?= e(url('/reminders/update')) ?>" class="card shadow-sm">
    <div class="card-body p-4">
        <?= csrf_field() ?>
        <input type="hidden" name="id" value="<?= e((string) $values['id']) ?>">

        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label">العنوان</label>
                <input type="text" name="title" class="form-control" maxlength="160" required value="<?= e((string) $values['title']) ?>">
            </div>
            <div class="col-md-3">
                <label class="form-label">المبلغ (اختياري)</label>
                <input type="number" step="0.01" min="0" name="amount" class="form-control" value="<?= e((string) $values['amount']) ?>">
            </div>
            <div class="col-md-3">
                <label class="form-label">تاريخ الاستحقاق</label>
                <input type="date" name="due_date" class="form-control" required value="<?= e((string) $values['due_date']) ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">الحالة</label>
                <select name="status" class="form-select" required>
                    <?php foreach ($statuses as $key => $label): ?>
                        <option value="<?= e($key) ?>" <?= $values['status'] === $key ? 'selected' : '' ?>><?= e($label) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-8">
                <label class="form-label">ملاحظات</label>
                <textarea name="notes" class="form-control" rows="3" maxlength="1000"><?= e((string) $values['notes']) ?></textarea>
            </div>
        </div>
    </div>
    <div class="card-footer bg-white d-flex justify-content-end">
        <button type="submit" class="btn btn-primary">حفظ التعديلات</button>
    </div>
</form>
