<?php
$activeType = $type === 'expense' ? 'expense' : 'income';
$pageTitle = $activeType === 'income' ? 'الإيرادات المتكررة' : 'المصروفات المتكررة';
$editBasePath = $activeType === 'income' ? '/recurring/incomes/edit' : '/recurring/expenses/edit';
$createValues = [
    'amount' => $oldInput['amount'] ?? '',
    'category_id' => $oldInput['category_id'] ?? '',
    'description' => $oldInput['description'] ?? '',
    'day_of_month' => $oldInput['day_of_month'] ?? '',
];
?>

<div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
    <h1 class="h3 mb-0"><?= e($pageTitle) ?></h1>
</div>

<div class="card shadow-sm mb-3">
    <div class="card-body d-flex flex-wrap gap-3 align-items-center">
        <form method="post" action="<?= e(url('/recurring/generate')) ?>" class="d-flex flex-wrap gap-2 align-items-center">
            <?= csrf_field() ?>
            <input type="hidden" name="type" value="<?= e($activeType) ?>">
            <div class="form-check">
                <input class="form-check-input" type="checkbox" value="yes" id="confirm-generate" name="confirm">
                <label class="form-check-label" for="confirm-generate">تأكيد توليد الكل لهذا الشهر</label>
            </div>
            <button type="submit" class="btn btn-warning">توليد الكل لهذا الشهر</button>
        </form>
        <small class="text-muted">زر الكل يولد جميع السجلات النشطة في هذه الصفحة فقط، ويمكنك التوليد الفردي من الإجراءات.</small>
    </div>
</div>

<div class="mb-4 text-muted small">
    النوع الحالي: <strong><?= e($pageTitle) ?></strong>
</div>

<div class="row g-4">
    <div class="col-lg-4">
        <form method="post" action="<?= e(url('/recurring/store')) ?>" class="card shadow-sm">
            <div class="card-body">
                <h2 class="h5 mb-3">إضافة سجل متكرر</h2>
                <?= csrf_field() ?>
                <input type="hidden" name="type" value="<?= e($activeType) ?>">

                <div class="mb-3">
                    <label class="form-label">المبلغ</label>
                    <input type="number" step="0.01" min="0.01" name="amount" class="form-control" required value="<?= e((string) $createValues['amount']) ?>">
                </div>
                <div class="mb-3">
                    <label class="form-label">التصنيف</label>
                    <select name="category_id" class="form-select">
                        <option value="">بدون تصنيف</option>
                        <?php foreach ($categories as $category): ?>
                            <?php
                            $label = (string) $category['name'];
                            if ((int) $category['is_active'] === 0) {
                                $label .= ' (Archived)';
                            }
                            ?>
                            <option value="<?= e($category['id']) ?>" <?= (string) $createValues['category_id'] === (string) $category['id'] ? 'selected' : '' ?>><?= e($label) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">الوصف</label>
                    <textarea name="description" class="form-control" rows="3" maxlength="500" required><?= e((string) $createValues['description']) ?></textarea>
                </div>
                <div class="mb-0">
                    <label class="form-label">يوم من الشهر</label>
                    <input type="number" min="1" max="31" name="day_of_month" class="form-control" required value="<?= e((string) $createValues['day_of_month']) ?>">
                </div>
            </div>
            <div class="card-footer bg-white d-flex justify-content-end">
                <button type="submit" class="btn btn-primary">حفظ</button>
            </div>
        </form>
    </div>

    <div class="col-lg-8">
        <div class="card shadow-sm">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0 align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>الوصف</th>
                                <th>اليوم</th>
                                <th>المبلغ</th>
                                <th>الحالة</th>
                                <th class="text-end">الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php if ($records === []): ?>
                            <tr><td colspan="5" class="text-center py-4 text-muted">لا توجد سجلات متكررة.</td></tr>
                        <?php else: ?>
                            <?php foreach ($records as $record): ?>
                                <tr>
                                    <td><?= e($record['description']) ?></td>
                                    <td><?= e((string) $record['day_of_month']) ?></td>
                                    <td><?= e(format_money((float) $record['amount'])) ?></td>
                                    <td><?= (int) $record['is_active'] === 1 ? 'نشط' : 'مؤرشف' ?></td>
                                    <td class="text-end">
                                        <form method="post" action="<?= e(url('/recurring/generate-single')) ?>" class="d-inline">
                                            <?= csrf_field() ?>
                                            <input type="hidden" name="type" value="<?= e($activeType) ?>">
                                            <input type="hidden" name="id" value="<?= e($record['id']) ?>">
                                            <?php if ((int) $record['is_active'] === 1): ?>
                                                <button type="submit" class="btn btn-sm btn-outline-success" onclick="return confirm('توليد هذا السجل للشهر الحالي؟');">توليد</button>
                                            <?php else: ?>
                                                <button type="button" class="btn btn-sm btn-outline-secondary" disabled title="السجل غير نشط">توليد</button>
                                            <?php endif; ?>
                                        </form>
                                        <a class="btn btn-sm btn-outline-primary" href="<?= e(url($editBasePath . '?id=' . $record['id'])) ?>">تعديل</a>
                                        <form method="post" action="<?= e(url('/recurring/delete')) ?>" class="d-inline">
                                            <?= csrf_field() ?>
                                            <input type="hidden" name="type" value="<?= e($activeType) ?>">
                                            <input type="hidden" name="id" value="<?= e($record['id']) ?>">
                                            <button type="submit" class="btn btn-sm btn-outline-danger" onclick="return confirm('تأكيد حذف السجل؟');">حذف</button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
