<?php
$values = [
    'id' => $oldInput['id'] ?? $record['id'],
    'amount' => $oldInput['amount'] ?? $record['amount'],
    'category_id' => $oldInput['category_id'] ?? ($record['category_id'] ?? ''),
    'description' => $oldInput['description'] ?? $record['description'],
    'day_of_month' => $oldInput['day_of_month'] ?? $record['day_of_month'],
    'is_active' => (string) ($oldInput['is_active'] ?? $record['is_active']),
];
$backPath = $type === 'expense' ? '/recurring/expenses' : '/recurring/incomes';
?>

<div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
    <h1 class="h3 mb-0"><?= e($title ?? 'تعديل سجل متكرر') ?></h1>
    <a class="btn btn-outline-secondary" href="<?= e(url($backPath)) ?>">العودة للقائمة</a>
</div>

<form method="post" action="<?= e(url('/recurring/update')) ?>" class="card shadow-sm">
    <div class="card-body p-4">
        <?= csrf_field() ?>
        <input type="hidden" name="type" value="<?= e($type) ?>">
        <input type="hidden" name="id" value="<?= e((string) $values['id']) ?>">

        <div class="row g-3">
            <div class="col-md-3">
                <label class="form-label">المبلغ</label>
                <input type="number" step="0.01" min="0.01" name="amount" class="form-control" required value="<?= e((string) $values['amount']) ?>">
            </div>
            <div class="col-md-3">
                <label class="form-label">يوم الشهر</label>
                <input type="number" min="1" max="31" name="day_of_month" class="form-control" required value="<?= e((string) $values['day_of_month']) ?>">
            </div>
            <div class="col-md-3">
                <label class="form-label">الحالة</label>
                <select name="is_active" class="form-select" required>
                    <option value="1" <?= $values['is_active'] === '1' ? 'selected' : '' ?>>نشط</option>
                    <option value="0" <?= $values['is_active'] === '0' ? 'selected' : '' ?>>مؤرشف</option>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">التصنيف</label>
                <select name="category_id" class="form-select">
                    <option value="">بدون تصنيف</option>
                    <?php foreach ($categories as $category): ?>
                        <?php
                        $label = (string) $category['name'];
                        if ((int) $category['is_active'] === 0) {
                            $label .= ' (Archived)';
                        }
                        ?>
                        <option value="<?= e($category['id']) ?>" <?= (string) $values['category_id'] === (string) $category['id'] ? 'selected' : '' ?>><?= e($label) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-12">
                <label class="form-label">الوصف</label>
                <textarea name="description" class="form-control" rows="4" maxlength="500" required><?= e((string) $values['description']) ?></textarea>
            </div>
        </div>
    </div>
    <div class="card-footer bg-white d-flex justify-content-end">
        <button type="submit" class="btn btn-primary">حفظ</button>
    </div>
</form>
