<!doctype html>
<html lang="<?= e(app_lang()) ?>" dir="<?= e(app_dir()) ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?= e(isset($title) && $title !== '' ? ($title . ' - ' . app_name()) : app_name()) ?></title>
    <link rel="stylesheet" href="<?= e(bootstrap_css_url()) ?>">
    <link rel="stylesheet" href="<?= e(url('/assets/css/app.css')) ?>">
</head>
<body class="app-shell">
<?php
$user = auth_user();
$currentPath = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH) ?: '/';
if (APP_BASE_URL !== '' && str_starts_with($currentPath, APP_BASE_URL)) {
    $currentPath = substr($currentPath, strlen(APP_BASE_URL));
    $currentPath = $currentPath === '' ? '/' : $currentPath;
}
$currentPath = '/' . trim($currentPath, '/');
if ($currentPath === '//') {
    $currentPath = '/';
}
$currentPath = rtrim($currentPath, '/');
$currentPath = $currentPath === '' ? '/' : $currentPath;

$isActiveMenu = static function (string $href) use ($currentPath): bool {
    $menuPath = parse_url($href, PHP_URL_PATH) ?: '/';
    $menuPath = '/' . trim($menuPath, '/');
    if ($menuPath === '//') {
        $menuPath = '/';
    }
    $menuPath = rtrim($menuPath, '/');
    $menuPath = $menuPath === '' ? '/' : $menuPath;

    if ($menuPath === '/') {
        return $currentPath === '/';
    }

    return $currentPath === $menuPath || str_starts_with($currentPath, $menuPath . '/');
};

$menuItems = [
    ['perm' => 'dashboard.view', 'label' => 'لوحة التحكم', 'href' => '/'],
    ['perm' => 'incomes.view', 'label' => 'الإيرادات', 'href' => '/incomes'],
    ['perm' => 'expenses.view', 'label' => 'المصروفات', 'href' => '/expenses'],
    ['perm' => 'recurring.view', 'label' => 'تكرار الإيرادات', 'href' => '/recurring/incomes'],
    ['perm' => 'recurring.view', 'label' => 'تكرار المصروفات', 'href' => '/recurring/expenses'],
    ['perm' => 'sent.view', 'label' => 'المرسل', 'href' => '/sent-money'],
    ['perm' => 'borrowed.view', 'label' => 'المقترض', 'href' => '/borrowed-money'],
    ['perm' => 'reminders.view', 'label' => 'التذكيرات', 'href' => '/reminders'],
    ['perm' => 'reports.view', 'label' => 'التقارير', 'href' => '/reports'],
    ['perm' => 'search.view', 'label' => 'البحث', 'href' => '/search'],
    ['perm' => 'settings.manage', 'label' => 'الإعدادات', 'href' => '/settings'],
    ['perm' => 'backup.manage', 'label' => 'النسخ الاحتياطي', 'href' => '/backup'],
    ['perm' => 'users.manage', 'label' => 'المستخدمون', 'href' => '/users'],
    ['perm' => 'roles.manage', 'label' => 'الصلاحيات', 'href' => '/roles'],
];
?>

<?php if ($user): ?>
    <header class="app-mobile-topbar d-lg-none">
        <div class="container-fluid d-flex justify-content-between align-items-center py-2">
            <button class="btn btn-outline-light btn-sm" type="button" data-bs-toggle="offcanvas" data-bs-target="#mobileSidebar" aria-controls="mobileSidebar">القائمة</button>
            <a class="text-light text-decoration-none fw-semibold" href="<?= e(url('/')) ?>"><?= e(app_name()) ?></a>
        </div>
    </header>

    <div class="offcanvas offcanvas-end app-mobile-sidebar" tabindex="-1" id="mobileSidebar" aria-labelledby="mobileSidebarLabel">
        <div class="offcanvas-header border-bottom border-secondary-subtle">
            <h5 class="offcanvas-title" id="mobileSidebarLabel">القائمة</h5>
            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div class="offcanvas-body d-flex flex-column">
            <div class="text-white-50 small mb-3"><?= e($user['name']) ?></div>
            <ul class="nav nav-pills flex-column gap-1">
                <?php foreach ($menuItems as $item): ?>
                    <?php if (can($item['perm'])): ?>
                        <li class="nav-item">
                            <a class="nav-link<?= $isActiveMenu($item['href']) ? ' active' : '' ?>" href="<?= e(url($item['href'])) ?>"><?= e($item['label']) ?></a>
                        </li>
                    <?php endif; ?>
                <?php endforeach; ?>
            </ul>
            <div class="mt-auto pt-3">
                <form method="post" action="<?= e(url('/logout')) ?>">
                    <?= csrf_field() ?>
                    <button type="submit" class="btn btn-outline-light w-100">خروج</button>
                </form>
            </div>
        </div>
    </div>

    <aside class="app-sidebar d-none d-lg-flex flex-column">
        <div class="app-sidebar-brand px-3 py-3 border-bottom border-secondary-subtle">
            <a class="text-light text-decoration-none fw-semibold" href="<?= e(url('/')) ?>"><?= e(app_name()) ?></a>
        </div>
        <div class="px-3 py-2 text-white-50 small border-bottom border-secondary-subtle"><?= e($user['name']) ?></div>
        <nav class="p-2 flex-grow-1 overflow-auto">
            <ul class="nav nav-pills flex-column gap-1">
                <?php foreach ($menuItems as $item): ?>
                    <?php if (can($item['perm'])): ?>
                        <li class="nav-item">
                            <a class="nav-link<?= $isActiveMenu($item['href']) ? ' active' : '' ?>" href="<?= e(url($item['href'])) ?>"><?= e($item['label']) ?></a>
                        </li>
                    <?php endif; ?>
                <?php endforeach; ?>
            </ul>
        </nav>
        <div class="p-3 border-top border-secondary-subtle">
            <form method="post" action="<?= e(url('/logout')) ?>">
                <?= csrf_field() ?>
                <button type="submit" class="btn btn-outline-light w-100">خروج</button>
            </form>
        </div>
    </aside>

    <main class="app-main with-sidebar">
        <div class="container-fluid py-4">
            <?php if ($successMessage = flash('success')): ?>
                <div class="alert alert-success"><?= e($successMessage) ?></div>
            <?php endif; ?>
            <?php if ($errorMessage = flash('error')): ?>
                <div class="alert alert-danger"><?= e($errorMessage) ?></div>
            <?php endif; ?>
            <?= $content ?? '' ?>
        </div>
    </main>
<?php else: ?>
    <main class="container py-4">
        <?php if ($successMessage = flash('success')): ?>
            <div class="alert alert-success"><?= e($successMessage) ?></div>
        <?php endif; ?>
        <?php if ($errorMessage = flash('error')): ?>
            <div class="alert alert-danger"><?= e($errorMessage) ?></div>
        <?php endif; ?>
        <?= $content ?? '' ?>
    </main>
<?php endif; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="<?= e(url('/assets/js/app.js')) ?>"></script>
</body>
</html>
