<?php $alerts = $stats['alerts']; ?>

<div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
    <h1 class="h3 mb-0">لوحة التحكم</h1>
    <a class="btn btn-outline-secondary" href="<?= e(url('/health')) ?>">فحص النظام</a>
</div>

<?php if ($filterErrors !== []): ?>
    <div class="alert alert-warning">
        <?= e(implode(' ', $filterErrors)) ?>
    </div>
<?php endif; ?>

<div class="card shadow-sm mb-3">
    <div class="card-body">
        <form method="get" action="<?= e(url('/')) ?>" class="row g-2 align-items-end">
            <div class="col-md-4">
                <label class="form-label">من تاريخ</label>
                <input type="date" name="date_from" class="form-control" value="<?= e((string) ($filters['date_from'] ?? '')) ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">إلى تاريخ</label>
                <input type="date" name="date_to" class="form-control" value="<?= e((string) ($filters['date_to'] ?? '')) ?>">
            </div>
            <div class="col-md-4 d-flex gap-2">
                <button type="submit" class="btn btn-outline-primary w-100">تصفية</button>
                <a class="btn btn-outline-secondary w-100" href="<?= e(url('/')) ?>">إعادة ضبط</a>
            </div>
        </form>
        <small class="text-muted d-block mt-2">
            الفلترة تعتمد على: تاريخ الإيراد/المصروف، تاريخ الاستلام المتوقع للمرسل، وتاريخ السداد المتوقع للمقترض.
        </small>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-6 col-xl-2">
        <div class="card shadow-sm h-100">
            <div class="card-body">
                <div class="text-muted small mb-1">إجمالي الإيرادات</div>
                <div class="h4 mb-0"><?= e(format_money((float) $stats['total_income'])) ?></div>
            </div>
        </div>
    </div>
    <div class="col-md-6 col-xl-2">
        <div class="card shadow-sm h-100">
            <div class="card-body">
                <div class="text-muted small mb-1">إجمالي المصروفات</div>
                <div class="h4 mb-0"><?= e(format_money((float) $stats['total_expense'])) ?></div>
            </div>
        </div>
    </div>
    <div class="col-md-6 col-xl-2">
        <div class="card shadow-sm h-100">
            <div class="card-body">
                <div class="text-muted small mb-1">إجمالي المرسل</div>
                <div class="h4 mb-0"><?= e(format_money((float) $stats['total_sent'])) ?></div>
            </div>
        </div>
    </div>
    <div class="col-md-6 col-xl-2">
        <div class="card shadow-sm h-100">
            <div class="card-body">
                <div class="text-muted small mb-1">إجمالي المقترض</div>
                <div class="h4 mb-0"><?= e(format_money((float) $stats['total_borrowed'])) ?></div>
            </div>
        </div>
    </div>
    <div class="col-md-6 col-xl-2">
        <div class="card shadow-sm h-100">
            <div class="card-body">
                <div class="text-muted small mb-1">الرصيد الحالي</div>
                <div class="h4 mb-0"><?= e(format_money((float) $stats['current_balance'])) ?></div>
            </div>
        </div>
    </div>
    <div class="col-md-6 col-xl-2">
        <div class="card shadow-sm h-100 border-primary">
            <div class="card-body">
                <div class="text-muted small mb-1">الرصيد الفعّال</div>
                <div class="h4 mb-0"><?= e(format_money((float) $stats['effective_balance'])) ?></div>
                <div class="small text-muted mt-2">
                    مرسل نشط: <?= e(format_money((float) $stats['active_sent'])) ?>
                    | مقترض نشط: <?= e(format_money((float) $stats['active_borrowed'])) ?>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-4">
        <div class="alert alert-warning mb-0 d-flex justify-content-between align-items-center">
            <span>تذكيرات متأخرة</span>
            <strong><?= e((string) $alerts['overdue_reminders']) ?></strong>
        </div>
    </div>
    <div class="col-md-4">
        <div class="alert alert-danger mb-0 d-flex justify-content-between align-items-center">
            <span>مبالغ مرسلة متأخرة</span>
            <strong><?= e((string) $alerts['overdue_sent']) ?></strong>
        </div>
    </div>
    <div class="col-md-4">
        <div class="alert alert-info mb-0 d-flex justify-content-between align-items-center">
            <span>مبالغ مقترضة متأخرة</span>
            <strong><?= e((string) $alerts['overdue_borrowed']) ?></strong>
        </div>
    </div>
</div>

<div class="card shadow-sm">
    <div class="card-body">
        <h2 class="h5 mb-3">روابط سريعة</h2>
        <div class="d-flex flex-wrap gap-2">
            <a class="btn btn-outline-primary" href="<?= e(url('/incomes')) ?>">الإيرادات</a>
            <a class="btn btn-outline-primary" href="<?= e(url('/expenses')) ?>">المصروفات</a>
            <a class="btn btn-outline-primary" href="<?= e(url('/sent-money')) ?>">المرسل</a>
            <a class="btn btn-outline-primary" href="<?= e(url('/borrowed-money')) ?>">المقترض</a>
            <a class="btn btn-outline-primary" href="<?= e(url('/reminders')) ?>">التذكيرات</a>
            <a class="btn btn-outline-primary" href="<?= e(url('/reports')) ?>">التقارير</a>
        </div>
    </div>
</div>
