<?php
$createValues = [
    'amount' => $oldInput['amount'] ?? '',
    'category_id' => $oldInput['category_id'] ?? '',
    'description' => $oldInput['description'] ?? '',
    'date' => $oldInput['date'] ?? date('Y-m-d'),
];
?>

<div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
    <h1 class="h3 mb-0">المصروفات</h1>
</div>

<?php if ($filterErrors !== []): ?>
    <div class="alert alert-warning">
        <?= e(implode(' ', $filterErrors)) ?>
    </div>
<?php endif; ?>

<div class="row g-4">
    <div class="col-lg-4">
        <form method="post" action="<?= e(url('/expenses/store')) ?>" class="card shadow-sm">
            <div class="card-body">
                <h2 class="h5 mb-3">إضافة مصروف</h2>
                <?= csrf_field() ?>

                <div class="mb-3">
                    <label class="form-label">المبلغ</label>
                    <input type="number" step="0.01" min="0.01" name="amount" class="form-control" required value="<?= e((string) $createValues['amount']) ?>">
                </div>

                <div class="mb-3">
                    <label class="form-label">التصنيف</label>
                    <select name="category_id" class="form-select">
                        <option value="">بدون تصنيف</option>
                        <?php foreach ($categories as $category): ?>
                            <?php
                            $label = (string) $category['name'];
                            if ((int) $category['is_active'] === 0) {
                                $label .= ' (Archived)';
                            }
                            ?>
                            <option value="<?= e($category['id']) ?>" <?= (string) $createValues['category_id'] === (string) $category['id'] ? 'selected' : '' ?>>
                                <?= e($label) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="mb-3">
                    <label class="form-label">الوصف</label>
                    <textarea name="description" class="form-control" rows="3" maxlength="500" required><?= e((string) $createValues['description']) ?></textarea>
                </div>

                <div class="mb-3">
                    <label class="form-label">التاريخ</label>
                    <input type="date" name="date" class="form-control" required value="<?= e((string) $createValues['date']) ?>">
                </div>
            </div>
            <div class="card-footer bg-white d-flex justify-content-end">
                <button type="submit" class="btn btn-primary">حفظ</button>
            </div>
        </form>
    </div>

    <div class="col-lg-8">
        <div class="card shadow-sm mb-3">
            <div class="card-body">
                <form method="get" action="<?= e(url('/expenses')) ?>" class="row g-2 align-items-end">
                    <div class="col-md-4">
                        <label class="form-label">من تاريخ</label>
                        <input type="date" name="date_from" class="form-control" value="<?= e($filters['date_from']) ?>">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">إلى تاريخ</label>
                        <input type="date" name="date_to" class="form-control" value="<?= e($filters['date_to']) ?>">
                    </div>
                    <div class="col-md-4 d-flex gap-2">
                        <button type="submit" class="btn btn-outline-primary w-100">تصفية</button>
                        <a class="btn btn-outline-secondary w-100" href="<?= e(url('/expenses')) ?>">إعادة ضبط</a>
                    </div>
                </form>
            </div>
        </div>

        <div class="card shadow-sm mb-3">
            <div class="card-body d-flex flex-wrap gap-4">
                <div>
                    <div class="text-muted small">عدد السجلات</div>
                    <div class="fw-bold"><?= e((string) $summary['count']) ?></div>
                </div>
                <div>
                    <div class="text-muted small">إجمالي المصروفات (حسب الفلتر)</div>
                    <div class="fw-bold"><?= e(format_money((float) $summary['amount'])) ?></div>
                </div>
            </div>
        </div>

        <div class="card shadow-sm">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0 align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>التاريخ</th>
                                <th>الوصف</th>
                                <th>التصنيف</th>
                                <th>المبلغ</th>
                                <th class="text-end">الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php if ($expenses === []): ?>
                            <tr>
                                <td colspan="5" class="text-center py-4 text-muted">لا توجد مصروفات مطابقة.</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($expenses as $expense): ?>
                                <?php
                                $categoryLabel = '-';
                                if ((string) $expense['category_id'] !== '') {
                                    if ($expense['category_name'] !== null) {
                                        $categoryLabel = (string) $expense['category_name'];
                                        if ((int) $expense['category_is_active'] === 0) {
                                            $categoryLabel .= ' (Archived)';
                                        }
                                    } else {
                                        $categoryLabel = 'غير معروف (Archived)';
                                    }
                                }
                                ?>
                                <tr>
                                    <td><?= e($expense['date']) ?></td>
                                    <td><?= e(display_description($expense['description'])) ?></td>
                                    <td><?= e($categoryLabel) ?></td>
                                    <td><?= e(format_money((float) $expense['amount'])) ?></td>
                                    <td class="text-end">
                                        <a class="btn btn-sm btn-outline-primary" href="<?= e(url('/expenses/edit?id=' . $expense['id'])) ?>">تعديل</a>
                                        <form method="post" action="<?= e(url('/expenses/delete')) ?>" class="d-inline">
                                            <?= csrf_field() ?>
                                            <input type="hidden" name="id" value="<?= e($expense['id']) ?>">
                                            <button type="submit" class="btn btn-sm btn-outline-danger" onclick="return confirm('تأكيد حذف المصروف؟');">حذف</button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
