<?php
$values = [
    'id' => $oldInput['id'] ?? $expense['id'],
    'amount' => $oldInput['amount'] ?? $expense['amount'],
    'category_id' => $oldInput['category_id'] ?? ($expense['category_id'] ?? ''),
    'description' => $oldInput['description'] ?? display_description($expense['description']),
    'date' => $oldInput['date'] ?? $expense['date'],
];
?>

<div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
    <h1 class="h3 mb-0">تعديل المصروف</h1>
    <a class="btn btn-outline-secondary" href="<?= e(url('/expenses')) ?>">العودة للقائمة</a>
</div>

<form method="post" action="<?= e(url('/expenses/update')) ?>" class="card shadow-sm">
    <div class="card-body p-4">
        <?= csrf_field() ?>
        <input type="hidden" name="id" value="<?= e((string) $values['id']) ?>">

        <div class="row g-3">
            <div class="col-md-4">
                <label class="form-label">المبلغ</label>
                <input type="number" step="0.01" min="0.01" name="amount" class="form-control" required value="<?= e((string) $values['amount']) ?>">
            </div>

            <div class="col-md-4">
                <label class="form-label">التصنيف</label>
                <select name="category_id" class="form-select">
                    <option value="">بدون تصنيف</option>
                    <?php foreach ($categories as $category): ?>
                        <?php
                        $label = (string) $category['name'];
                        if ((int) $category['is_active'] === 0) {
                            $label .= ' (Archived)';
                        }
                        ?>
                        <option value="<?= e($category['id']) ?>" <?= (string) $values['category_id'] === (string) $category['id'] ? 'selected' : '' ?>>
                            <?= e($label) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-md-4">
                <label class="form-label">التاريخ</label>
                <input type="date" name="date" class="form-control" required value="<?= e((string) $values['date']) ?>">
            </div>

            <div class="col-12">
                <label class="form-label">الوصف</label>
                <textarea name="description" class="form-control" rows="4" maxlength="500" required><?= e((string) $values['description']) ?></textarea>
            </div>
        </div>
    </div>
    <div class="card-footer bg-white d-flex justify-content-end">
        <button type="submit" class="btn btn-primary">حفظ التعديلات</button>
    </div>
</form>
