<?php
$activeType = $type === 'expense' ? 'expense' : 'income';
$newName = $oldInput['name'] ?? '';
?>

<div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
    <h1 class="h3 mb-0">إدارة التصنيفات</h1>
    <a class="btn btn-outline-secondary" href="<?= e(url('/settings')) ?>">العودة للإعدادات</a>
</div>

<ul class="nav nav-pills mb-4">
    <li class="nav-item">
        <a class="nav-link <?= $activeType === 'income' ? 'active' : '' ?>" href="<?= e(url('/categories?type=income')) ?>">تصنيفات الإيراد</a>
    </li>
    <li class="nav-item">
        <a class="nav-link <?= $activeType === 'expense' ? 'active' : '' ?>" href="<?= e(url('/categories?type=expense')) ?>">تصنيفات المصروف</a>
    </li>
</ul>

<div class="row g-4">
    <div class="col-lg-5">
        <form method="post" action="<?= e(url('/categories/store')) ?>" class="card shadow-sm">
            <div class="card-body">
                <h2 class="h5 mb-3">إضافة تصنيف جديد</h2>
                <?= csrf_field() ?>
                <input type="hidden" name="type" value="<?= e($activeType) ?>">
                <input type="hidden" name="return_to" value="<?= e('/categories?type=' . $activeType) ?>">

                <label class="form-label">اسم التصنيف</label>
                <input type="text" name="name" class="form-control" maxlength="100" required value="<?= e($newName) ?>">
            </div>
            <div class="card-footer bg-white d-flex justify-content-end">
                <button type="submit" class="btn btn-primary">إضافة</button>
            </div>
        </form>
    </div>

    <div class="col-lg-7">
        <div class="card shadow-sm">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0 align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>الاسم</th>
                                <th>الحالة</th>
                                <th>تاريخ الإنشاء</th>
                                <th class="text-end">الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php if ($categories === []): ?>
                            <tr>
                                <td colspan="4" class="text-center py-4 text-muted">لا توجد تصنيفات حالياً.</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($categories as $category): ?>
                                <tr>
                                    <td><?= e($category['name']) ?></td>
                                    <td>
                                        <?php if ((int) $category['is_active'] === 1): ?>
                                            <span class="badge text-bg-success">نشط</span>
                                        <?php else: ?>
                                            <span class="badge text-bg-secondary">مؤرشف</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?= e($category['created_at']) ?></td>
                                    <td class="text-end">
                                        <a class="btn btn-sm btn-outline-primary" href="<?= e(url('/categories/edit?id=' . $category['id'])) ?>">تعديل</a>
                                        <?php if ((int) $category['is_active'] === 1): ?>
                                            <form method="post" action="<?= e(url('/categories/deactivate')) ?>" class="d-inline">
                                                <?= csrf_field() ?>
                                                <input type="hidden" name="id" value="<?= e($category['id']) ?>">
                                                <input type="hidden" name="type" value="<?= e($activeType) ?>">
                                                <input type="hidden" name="return_to" value="<?= e('/categories?type=' . $activeType) ?>">
                                                <button type="submit" class="btn btn-sm btn-outline-danger" onclick="return confirm('تأكيد تعطيل التصنيف؟');">تعطيل</button>
                                            </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
