<?php
$values = [
    'id' => $oldInput['id'] ?? $category['id'],
    'type' => $oldInput['type'] ?? $category['type'],
    'name' => $oldInput['name'] ?? $category['name'],
    'is_active' => (string) ($oldInput['is_active'] ?? $category['is_active']),
];
?>

<div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
    <h1 class="h3 mb-0">تعديل التصنيف</h1>
    <a class="btn btn-outline-secondary" href="<?= e(url('/categories?type=' . $category['type'])) ?>">العودة للقائمة</a>
</div>

<form method="post" action="<?= e(url('/categories/update')) ?>" class="card shadow-sm">
    <div class="card-body p-4">
        <?= csrf_field() ?>
        <input type="hidden" name="id" value="<?= e($values['id']) ?>">
        <input type="hidden" name="return_to" value="<?= e('/categories?type=' . $category['type']) ?>">

        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label">النوع</label>
                <select name="type" class="form-select" required>
                    <option value="income" <?= $values['type'] === 'income' ? 'selected' : '' ?>>Income</option>
                    <option value="expense" <?= $values['type'] === 'expense' ? 'selected' : '' ?>>Expense</option>
                </select>
            </div>

            <div class="col-md-6">
                <label class="form-label">اسم التصنيف</label>
                <input type="text" name="name" class="form-control" maxlength="100" required value="<?= e($values['name']) ?>">
            </div>

            <div class="col-md-6">
                <label class="form-label">الحالة</label>
                <select name="is_active" class="form-select" required>
                    <option value="1" <?= $values['is_active'] === '1' ? 'selected' : '' ?>>نشط</option>
                    <option value="0" <?= $values['is_active'] === '0' ? 'selected' : '' ?>>مؤرشف</option>
                </select>
            </div>
        </div>
    </div>
    <div class="card-footer bg-white d-flex justify-content-end">
        <button type="submit" class="btn btn-primary">حفظ التعديلات</button>
    </div>
</form>
