<div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
    <h1 class="h3 mb-0">النسخ الاحتياطي والاستعادة</h1>
</div>

<div class="alert alert-danger">
    العمليات أدناه قد تستبدل البيانات بالكامل. تأكد من تنزيل نسخة احتياطية قبل أي استعادة أو إعادة ضبط.
</div>

<div class="row g-4">
    <div class="col-lg-6">
        <div class="card shadow-sm">
            <div class="card-body">
                <h2 class="h5">نسخ احتياطي</h2>
                <div class="d-flex flex-wrap gap-2 mt-3">
                    <a class="btn btn-outline-primary" href="<?= e(url('/backup/download-db')) ?>">تنزيل ملف SQLite</a>
                    <a class="btn btn-outline-secondary" href="<?= e(url('/backup/export-json')) ?>">تنزيل JSON كامل</a>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-6">
        <form method="post" action="<?= e(url('/backup/restore-sqlite')) ?>" enctype="multipart/form-data" class="card shadow-sm">
            <div class="card-body">
                <h2 class="h5">استعادة SQLite</h2>
                <?= csrf_field() ?>
                <div class="mb-3 mt-3">
                    <label class="form-label">ملف SQLite</label>
                    <input type="file" name="sqlite_file" class="form-control" accept=".sqlite" required>
                </div>
                <div class="mb-0">
                    <label class="form-label">تأكيد (اكتب RESTORE)</label>
                    <input type="text" name="confirm_restore" class="form-control" required>
                </div>
            </div>
            <div class="card-footer bg-white d-flex justify-content-end">
                <button type="submit" class="btn btn-danger">استعادة</button>
            </div>
        </form>
    </div>

    <div class="col-lg-6">
        <form method="post" action="<?= e(url('/backup/import-json')) ?>" enctype="multipart/form-data" class="card shadow-sm">
            <div class="card-body">
                <h2 class="h5">استيراد JSON (استبدال كامل)</h2>
                <?= csrf_field() ?>
                <div class="mb-3 mt-3">
                    <label class="form-label">ملف JSON</label>
                    <input type="file" name="json_file" class="form-control" accept=".json,application/json" required>
                </div>
                <div class="mb-0">
                    <label class="form-label">تأكيد (اكتب REPLACE)</label>
                    <input type="text" name="confirm_import" class="form-control" required>
                </div>
            </div>
            <div class="card-footer bg-white d-flex justify-content-end">
                <button type="submit" class="btn btn-danger">استيراد JSON</button>
            </div>
        </form>
    </div>

    <div class="col-lg-6">
        <form method="post" action="<?= e(url('/backup/factory-reset')) ?>" class="card shadow-sm">
            <div class="card-body">
                <h2 class="h5">إعادة ضبط المصنع</h2>
                <?= csrf_field() ?>
                <p class="text-muted mb-3 mt-3">سيتم حذف كل البيانات الحالية وإعادة إنشاء قاعدة البيانات مع البيانات الافتراضية.</p>
                <div class="mb-0">
                    <label class="form-label">تأكيد (اكتب RESET)</label>
                    <input type="text" name="confirm_factory_reset" class="form-control" required>
                </div>
            </div>
            <div class="card-footer bg-white d-flex justify-content-end">
                <button type="submit" class="btn btn-danger">إعادة ضبط المصنع</button>
            </div>
        </form>
    </div>
</div>
