<?php
$name = (string) ($oldInput['name'] ?? '');
$email = (string) ($oldInput['email'] ?? '');
?>

<div class="row justify-content-center mt-5">
    <div class="col-md-7 col-lg-5">
        <div class="card shadow-sm">
            <div class="card-body p-4">
                <h1 class="h4 mb-3 text-center">إنشاء حساب جديد</h1>
                <form method="post" action="<?= e(url('/register')) ?>">
                    <?= csrf_field() ?>
                    <div class="mb-3">
                        <label class="form-label">الاسم</label>
                        <input type="text" name="name" class="form-control" maxlength="120" required value="<?= e($name) ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">البريد الإلكتروني</label>
                        <input type="email" name="email" class="form-control" required value="<?= e($email) ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">كلمة المرور</label>
                        <input type="password" name="password" class="form-control" minlength="8" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">تأكيد كلمة المرور</label>
                        <input type="password" name="password_confirm" class="form-control" minlength="8" required>
                    </div>
                    <div class="d-grid">
                        <button type="submit" class="btn btn-primary">إنشاء الحساب</button>
                    </div>
                </form>
                <hr>
                <div class="text-center small">
                    <a href="<?= e(url('/login')) ?>">لديك حساب؟ تسجيل الدخول</a>
                </div>
            </div>
        </div>
    </div>
</div>

