<?php
declare(strict_types=1);

namespace App\Models;

class SettingsModel extends BaseModel
{
    public function getFirst(): ?array
    {
        $stmt = $this->db->query('SELECT * FROM app_settings ORDER BY created_at ASC LIMIT 1');
        $row = $stmt->fetch();

        return $row ?: null;
    }

    public function update(string $id, array $data): bool
    {
        $stmt = $this->db->prepare(
            'UPDATE app_settings
             SET system_name = :system_name,
                 currency_code = :currency_code,
                 number_format = :number_format,
                 calendar_type = :calendar_type,
                 language = :language,
                 rtl = :rtl,
                 updated_at = :updated_at
             WHERE id = :id'
        );

        return $stmt->execute([
            ':id' => $id,
            ':system_name' => $data['system_name'],
            ':currency_code' => $data['currency_code'],
            ':number_format' => $data['number_format'],
            ':calendar_type' => $data['calendar_type'],
            ':language' => $data['language'],
            ':rtl' => $data['rtl'],
            ':updated_at' => $data['updated_at'],
        ]);
    }
}
