<?php
declare(strict_types=1);

namespace App\Models;

class CategoryModel extends BaseModel
{
    public function listByType(string $type): array
    {
        $stmt = $this->db->prepare(
            'SELECT id, type, name, is_active, created_at, updated_at
             FROM categories
             WHERE type = :type
             ORDER BY is_active DESC, name ASC'
        );
        $stmt->execute([':type' => $type]);

        return $stmt->fetchAll() ?: [];
    }

    public function findById(string $id): ?array
    {
        $stmt = $this->db->prepare(
            'SELECT id, type, name, is_active, created_at, updated_at
             FROM categories
             WHERE id = :id
             LIMIT 1'
        );
        $stmt->execute([':id' => $id]);
        $row = $stmt->fetch();

        return $row ?: null;
    }

    public function create(array $data): bool
    {
        $stmt = $this->db->prepare(
            'INSERT INTO categories (id, type, name, is_active, created_at, updated_at)
             VALUES (:id, :type, :name, :is_active, :created_at, :updated_at)'
        );

        return $stmt->execute([
            ':id' => $data['id'],
            ':type' => $data['type'],
            ':name' => $data['name'],
            ':is_active' => $data['is_active'],
            ':created_at' => $data['created_at'],
            ':updated_at' => $data['updated_at'],
        ]);
    }

    public function update(array $data): bool
    {
        $stmt = $this->db->prepare(
            'UPDATE categories
             SET type = :type,
                 name = :name,
                 is_active = :is_active,
                 updated_at = :updated_at
             WHERE id = :id'
        );

        return $stmt->execute([
            ':id' => $data['id'],
            ':type' => $data['type'],
            ':name' => $data['name'],
            ':is_active' => $data['is_active'],
            ':updated_at' => $data['updated_at'],
        ]);
    }

    public function deactivate(string $id, string $updatedAt): bool
    {
        $stmt = $this->db->prepare(
            'UPDATE categories
             SET is_active = 0,
                 updated_at = :updated_at
             WHERE id = :id'
        );

        return $stmt->execute([
            ':id' => $id,
            ':updated_at' => $updatedAt,
        ]);
    }

    public function existsByType(string $id, string $type): bool
    {
        $stmt = $this->db->prepare(
            'SELECT COUNT(*) AS total
             FROM categories
             WHERE id = :id AND type = :type'
        );
        $stmt->execute([
            ':id' => $id,
            ':type' => $type,
        ]);

        return (int) $stmt->fetch()['total'] > 0;
    }
}
