<?php
declare(strict_types=1);

namespace App\Models;

use App\Database\Connection;
use App\Services\AuthService;
use PDO;

abstract class BaseModel
{
    protected PDO $db;

    public function __construct()
    {
        $this->db = Connection::getInstance();
    }

    protected function shouldApplyUserScope(): bool
    {
        return AuthService::check() && !AuthService::isAdmin();
    }

    protected function currentUserId(): ?string
    {
        return AuthService::id();
    }

    protected function appendUserScope(array &$conditions, array &$params, string $column, string $paramKey = ':current_user_id'): void
    {
        if (!$this->shouldApplyUserScope()) {
            return;
        }

        $userId = $this->currentUserId();
        if ($userId === null || $userId === '') {
            $conditions[] = '1 = 0';
            return;
        }

        $conditions[] = $column . ' = ' . $paramKey;
        $params[$paramKey] = $userId;
    }

    protected function resolveInsertUserId(array $data): ?string
    {
        $explicitUserId = $data['user_id'] ?? null;
        if (is_string($explicitUserId) && trim($explicitUserId) !== '') {
            return trim($explicitUserId);
        }

        $currentUserId = $this->currentUserId();
        if (is_string($currentUserId) && $currentUserId !== '') {
            return $currentUserId;
        }

        return null;
    }
}
