<?php
declare(strict_types=1);

return [
    'name' => '20260216_000002_create_recurring_generation_log',
    'up' => static function (\PDO $db): void {
        $db->exec(
            'CREATE TABLE IF NOT EXISTS recurring_generation_log (
                id TEXT PRIMARY KEY,
                recurring_type TEXT NOT NULL CHECK(recurring_type IN ("income", "expense")),
                recurring_id TEXT NOT NULL,
                year INTEGER NOT NULL,
                month INTEGER NOT NULL,
                created_at TEXT NOT NULL
            )'
        );

        $db->exec(
            'CREATE UNIQUE INDEX IF NOT EXISTS idx_recurring_generation_unique
             ON recurring_generation_log(recurring_type, recurring_id, year, month)'
        );
    },
];
