<?php
declare(strict_types=1);

use App\Services\UuidService;

return [
    'name' => '20260216_000001_create_foundation',
    'up' => static function (\PDO $db): void {
        $db->exec('PRAGMA foreign_keys = ON');

        $db->exec(
            'CREATE TABLE IF NOT EXISTS categories (
                id TEXT PRIMARY KEY,
                type TEXT NOT NULL CHECK(type IN ("income", "expense")),
                name TEXT NOT NULL,
                is_active INTEGER NOT NULL DEFAULT 1,
                created_at TEXT NOT NULL,
                updated_at TEXT NOT NULL
            )'
        );

        $db->exec(
            'CREATE TABLE IF NOT EXISTS incomes (
                id TEXT PRIMARY KEY,
                amount REAL NOT NULL,
                category_id TEXT NULL,
                description TEXT NOT NULL,
                date TEXT NOT NULL,
                created_at TEXT NOT NULL,
                updated_at TEXT NOT NULL,
                FOREIGN KEY(category_id) REFERENCES categories(id)
            )'
        );

        $db->exec(
            'CREATE TABLE IF NOT EXISTS expenses (
                id TEXT PRIMARY KEY,
                amount REAL NOT NULL,
                category_id TEXT NULL,
                description TEXT NOT NULL,
                date TEXT NOT NULL,
                created_at TEXT NOT NULL,
                updated_at TEXT NOT NULL,
                FOREIGN KEY(category_id) REFERENCES categories(id)
            )'
        );

        $db->exec(
            'CREATE TABLE IF NOT EXISTS recurring_incomes (
                id TEXT PRIMARY KEY,
                amount REAL NOT NULL,
                category_id TEXT NULL,
                description TEXT NOT NULL,
                day_of_month INTEGER NOT NULL,
                is_active INTEGER NOT NULL DEFAULT 1,
                created_at TEXT NOT NULL,
                updated_at TEXT NOT NULL,
                FOREIGN KEY(category_id) REFERENCES categories(id)
            )'
        );

        $db->exec(
            'CREATE TABLE IF NOT EXISTS recurring_expenses (
                id TEXT PRIMARY KEY,
                amount REAL NOT NULL,
                category_id TEXT NULL,
                description TEXT NOT NULL,
                day_of_month INTEGER NOT NULL,
                is_active INTEGER NOT NULL DEFAULT 1,
                created_at TEXT NOT NULL,
                updated_at TEXT NOT NULL,
                FOREIGN KEY(category_id) REFERENCES categories(id)
            )'
        );

        $db->exec(
            'CREATE TABLE IF NOT EXISTS sent_money (
                id TEXT PRIMARY KEY,
                person_name TEXT NOT NULL,
                amount REAL NOT NULL,
                expected_receive_date TEXT NOT NULL,
                status TEXT NOT NULL,
                notes TEXT NULL,
                created_at TEXT NOT NULL,
                updated_at TEXT NOT NULL
            )'
        );

        $db->exec(
            'CREATE TABLE IF NOT EXISTS borrowed_money (
                id TEXT PRIMARY KEY,
                person_name TEXT NOT NULL,
                amount REAL NOT NULL,
                expected_pay_date TEXT NOT NULL,
                status TEXT NOT NULL,
                notes TEXT NULL,
                created_at TEXT NOT NULL,
                updated_at TEXT NOT NULL
            )'
        );

        $db->exec(
            'CREATE TABLE IF NOT EXISTS monthly_reminders (
                id TEXT PRIMARY KEY,
                title TEXT NOT NULL,
                amount REAL NULL,
                due_date TEXT NOT NULL,
                status TEXT NOT NULL,
                notes TEXT NULL,
                created_at TEXT NOT NULL,
                updated_at TEXT NOT NULL
            )'
        );

        $db->exec(
            'CREATE TABLE IF NOT EXISTS app_settings (
                id TEXT PRIMARY KEY,
                system_name TEXT NOT NULL,
                currency_code TEXT NOT NULL,
                number_format TEXT NOT NULL,
                calendar_type TEXT NOT NULL,
                language TEXT NOT NULL,
                rtl INTEGER NOT NULL,
                created_at TEXT NOT NULL,
                updated_at TEXT NOT NULL
            )'
        );

        $db->exec('CREATE INDEX IF NOT EXISTS idx_incomes_date ON incomes(date)');
        $db->exec('CREATE INDEX IF NOT EXISTS idx_expenses_date ON expenses(date)');
        $db->exec('CREATE INDEX IF NOT EXISTS idx_monthly_reminders_due_date ON monthly_reminders(due_date)');

        $db->exec('CREATE INDEX IF NOT EXISTS idx_sent_money_status ON sent_money(status)');
        $db->exec('CREATE INDEX IF NOT EXISTS idx_borrowed_money_status ON borrowed_money(status)');
        $db->exec('CREATE INDEX IF NOT EXISTS idx_monthly_reminders_status ON monthly_reminders(status)');

        $db->exec('CREATE INDEX IF NOT EXISTS idx_categories_type ON categories(type)');

        $now = date('Y-m-d H:i:s');

        $settingsCount = (int) $db->query('SELECT COUNT(*) AS total FROM app_settings')->fetch()['total'];
        if ($settingsCount === 0) {
            $insertSettings = $db->prepare(
                'INSERT INTO app_settings
                (id, system_name, currency_code, number_format, calendar_type, language, rtl, created_at, updated_at)
                VALUES (:id, :system_name, :currency_code, :number_format, :calendar_type, :language, :rtl, :created_at, :updated_at)'
            );

            $insertSettings->execute([
                ':id' => UuidService::v4(),
                ':system_name' => 'مدير الدخل والمصروفات',
                ':currency_code' => 'SAR',
                ':number_format' => '1,234.56',
                ':calendar_type' => 'gregorian',
                ':language' => 'ar',
                ':rtl' => 1,
                ':created_at' => $now,
                ':updated_at' => $now,
            ]);
        }

        $categoryCount = (int) $db->query('SELECT COUNT(*) AS total FROM categories')->fetch()['total'];
        if ($categoryCount === 0) {
            $defaults = [
                ['income', 'راتب'],
                ['income', 'عمل حر'],
                ['income', 'مكافآت'],
                ['income', 'استثمار'],
                ['income', 'أخرى'],
                ['expense', 'إيجار'],
                ['expense', 'طعام'],
                ['expense', 'مواصلات'],
                ['expense', 'فواتير'],
                ['expense', 'أخرى'],
            ];

            $insertCategory = $db->prepare(
                'INSERT INTO categories (id, type, name, is_active, created_at, updated_at)
                 VALUES (:id, :type, :name, :is_active, :created_at, :updated_at)'
            );

            foreach ($defaults as $item) {
                $insertCategory->execute([
                    ':id' => UuidService::v4(),
                    ':type' => $item[0],
                    ':name' => $item[1],
                    ':is_active' => 1,
                    ':created_at' => $now,
                    ':updated_at' => $now,
                ]);
            }
        }
    },
];
