<?php
declare(strict_types=1);

use App\Database\MigrationRunner;

define('BASE_PATH', dirname(__DIR__, 2));
require BASE_PATH . '/app/bootstrap.php';

$runner = new MigrationRunner();
$result = $runner->run();

echo 'Migrations scanned: ' . $result['total_files'] . PHP_EOL;
echo 'Ran: ' . count($result['ran']) . PHP_EOL;
echo 'Skipped: ' . count($result['skipped']) . PHP_EOL;

if ($result['ran'] !== []) {
    echo 'Applied migrations:' . PHP_EOL;
    foreach ($result['ran'] as $name) {
        echo ' - ' . $name . PHP_EOL;
    }
}
