<?php
declare(strict_types=1);

namespace App\Database;

use PDO;

class Connection
{
    private static ?PDO $pdo = null;
    private static ?string $databasePath = null;

    public static function getInstance(): PDO
    {
        if (self::$pdo instanceof PDO) {
            return self::$pdo;
        }

        $databasePath = self::databasePath();

        if (!file_exists($databasePath)) {
            touch($databasePath);
        }

        self::$pdo = new PDO('sqlite:' . $databasePath);
        self::$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        self::$pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);

        return self::$pdo;
    }

    public static function reset(): void
    {
        self::$pdo = null;
    }

    public static function databasePath(): string
    {
        if (self::$databasePath !== null) {
            return self::$databasePath;
        }

        self::$databasePath = STORAGE_PATH . '/app.sqlite';
        return self::$databasePath;
    }
}
