<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Database\MigrationRunner;

class MigrationController extends Controller
{
    public function run(): void
    {
        $configuredKey = getenv('MIGRATION_KEY') ?: '';
        $providedKey = $_GET['key'] ?? '';

        if (!is_string($providedKey) || $configuredKey === '' || !hash_equals($configuredKey, $providedKey)) {
            http_response_code(403);
            echo t('طلب الترحيل غير مصرح. اضبط MIGRATION_KEY ثم استدعِ /migrate?key=...');
            return;
        }

        $runner = new MigrationRunner();
        $result = $runner->run();

        $this->render('database/migrate', [
            'title' => 'تشغيل الترحيلات',
            'result' => $result,
        ]);
    }
}
