<?php
declare(strict_types=1);

namespace App\Controllers;

use RuntimeException;

abstract class Controller
{
    protected function render(string $view, array $data = [], string $layout = 'layouts/main'): void
    {
        $viewFile = BASE_PATH . '/app/Views/' . str_replace('.', '/', $view) . '.php';
        $layoutFile = BASE_PATH . '/app/Views/' . str_replace('.', '/', $layout) . '.php';

        if (!is_file($viewFile) || !is_file($layoutFile)) {
            throw new RuntimeException('View file not found.');
        }

        extract($data, EXTR_SKIP);

        ob_start();
        require $viewFile;
        $content = ob_get_clean();

        ob_start();
        require $layoutFile;
        $layoutOutput = (string) ob_get_clean();

        echo translate_text($layoutOutput);
    }
}
